const wheelSegments = [
  "1", "2", "3", "4", "50X", "5", "6", "7", "8", "9",
  "75X", "10", "11", "12", "13", "100X", "14", "15", "16", "17", "18", "25X"
];
const segmentAngle = 360 / wheelSegments.length;

function spinToIndex(wheelEl, index, callback) {
  const spins = 5;
  const finalAngle =
    spins * 360 +
    (360 - (index * segmentAngle + segmentAngle / 2));
  wheelEl.style.transform = `rotate(${finalAngle}deg)`;
  setTimeout(() => callback && callback(), 4000);
}

function getToken() {
  return localStorage.getItem("sc_token") || "";
}

function setupGameWheel() {
  const wheelGame = document.getElementById("wheelGame");
  const resultGame = document.getElementById("wheelResultGame");
  const btnSpinGame = document.getElementById("btnSpinGame");
  const slotSelect = document.getElementById("slotSelect");
  const betInput = document.getElementById("betInput");
  const walletPill = document.getElementById("gameWalletPill");
  const msgBox = document.getElementById("wheelMessage");

  if (!wheelGame || !resultGame || !btnSpinGame || !slotSelect || !betInput) return;

  wheelSegments.forEach(val => {
    const opt = document.createElement("option");
    opt.value = val;
    opt.textContent = val;
    slotSelect.appendChild(opt);
  });

  (async () => {
    try {
      const res = await fetch("/api/user/wallet", {
        headers: { "Authorization": "Bearer " + getToken() }
      });
      const data = await res.json();
      if (walletPill && res.ok) {
        walletPill.textContent = "Wallet: " + data.balance;
      }
    } catch (e) {}
  })();

  btnSpinGame.addEventListener("click", async () => {
    const bet = Number(betInput.value || "0");
    const guessedSlot = slotSelect.value;
    if (!bet || bet <= 0) {
      msgBox.textContent = "Enter valid bet amount";
      return;
    }
    msgBox.textContent = "";
    btnSpinGame.disabled = true;

    try {
      const res = await fetch("/api/user/spin", {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
          "Authorization": "Bearer " + getToken()
        },
        body: JSON.stringify({ betAmount: bet, guessedSlot })
      });
      const data = await res.json();
      if (!res.ok) {
        msgBox.textContent = data.message || "Spin failed";
        btnSpinGame.disabled = false;
        return;
      }

      const idx = data.segmentIndex;
      const value = data.resultSlot;
      const winAmount = data.winAmount;
      const finalBalance = data.finalBalance;

      spinToIndex(wheelGame, idx, () => {
        const badge = resultGame.querySelector(".badge-result");
        if (badge) badge.textContent = value;
        if (walletPill) walletPill.textContent = "Wallet: " + finalBalance;
        msgBox.textContent = winAmount > 0
          ? `You WON ${winAmount} coins!`
          : `No win this time.`;
        btnSpinGame.disabled = false;
      });
    } catch (e) {
      msgBox.textContent = "Error calling API";
      btnSpinGame.disabled = false;
    }
  });
}

document.addEventListener("DOMContentLoaded", setupGameWheel);
