function getToken(){
  return localStorage.getItem("sc_token") || "";
}
async function apiGet(url, fallback){
  try{
    const res = await fetch(url,{headers:{Authorization:"Bearer "+getToken()}});
    if(res.status === 401){
      console.warn("Session expired or logged in elsewhere");
    }
    if(!res.ok) throw new Error((await res.json().catch(()=>({}))).message || "Request failed");
    return await res.json();
  }catch(e){
    console.warn("Using fallback for", url, e.message);
    return fallback;
  }
}
async function apiPost(url, body){
  const res = await fetch(url,{
    method:"POST",
    headers:{
      "Content-Type":"application/json",
      Authorization:"Bearer "+getToken()
    },
    body:JSON.stringify(body||{})
  });
  const data = await res.json().catch(()=> ({}));
  if(res.status === 401){
    throw new Error(data.message || "Session expired or logged out from another device");
  }
  if(!res.ok) throw new Error(data.message || "Request failed");
  return data;
}
