// === V10: SHARE SETTINGS ===
//
// This assumes an app_settings table with columns: key (varchar), value_json (text).
// If your structure differs, adjust queries accordingly.
//
// Paste this into backend/src/routes/superadmin.js BEFORE module.exports:

router.get("/share-settings", async (req, res) => {
  try {
    const [rows] = await pool.query(
      "SELECT `key`, value_json FROM app_settings WHERE `key` IN ('share_title','share_description','share_image')"
    );
    const out = { share_title: "", share_description: "", share_image: "" };
    for (const r of rows) {
      let val = "";
      try {
        const parsed = JSON.parse(r.value_json);
        val = parsed.value ?? parsed;
      } catch {
        val = r.value_json;
      }
      if (r.key === "share_title") out.share_title = val;
      if (r.key === "share_description") out.share_description = val;
      if (r.key === "share_image") out.share_image = val;
    }
    res.json(out);
  } catch (err) {
    console.error("share-settings get error:", err);
    res.status(500).json({ message: "Internal server error" });
  }
});

router.post("/share-settings", async (req, res) => {
  const { share_title, share_description, share_image } = req.body;
  try {
    const rows = [
      { key: "share_title", value: share_title || "" },
      { key: "share_description", value: share_description || "" },
      { key: "share_image", value: share_image || "" }
    ];
    for (const r of rows) {
      const valJson = JSON.stringify({ value: r.value });
      await pool.query(
        "INSERT INTO app_settings (`key`, value_json) VALUES (?, ?) ON DUPLICATE KEY UPDATE value_json = VALUES(value_json)",
        [r.key, valJson]
      );
    }
    res.json({ success: true });
  } catch (err) {
    console.error("share-settings post error:", err);
    res.status(500).json({ message: "Internal server error" });
  }
});
