const socketio = require('socket.io');
function setupChat(server){
  const io = socketio(server, { cors:{ origin:"*" } });
  io.on('connection', socket => {
    socket.on('join', room => socket.join(room));
    socket.on('message', data => io.to(data.room).emit('message', data));
  });
  console.log('Socket.io started');
}
module.exports = { setupChat };
