const express = require("express");
const cors = require("cors");
require("dotenv").config();

const { verifyToken, requireRole } = require("./middleware/auth");

const authRoutes = require("./routes/auth");
const userRoutes = require("./routes/user");
const superadminRoutes = require("./routes/superadmin");
const agentRoutes = require("./routes/agent");
const withdrawalRoutes = require("./routes/withdrawals");
const paymentRoutes = require("./routes/payments");
const chatRoutes = require("./routes/chat");
const developerRoutes = require("./routes/developer");

const app = express();
app.use(cors());
app.use(express.json());

app.get("/api/health", (req, res) => {
  res.json({ status: "ok", app: "Select Color App" });
});

app.use("/api/auth", authRoutes);
app.use("/api/user", verifyToken, requireRole("user"), userRoutes);
app.use("/api/superadmin", verifyToken, requireRole("superadmin"), superadminRoutes);
app.use("/api/agent", verifyToken, requireRole("agent"), agentRoutes);
app.use("/api/withdrawals", verifyToken, withdrawalRoutes);
app.use("/api/payments", verifyToken, paymentRoutes);
app.use("/api/chat", verifyToken, chatRoutes);
app.use("/api/developer", verifyToken, requireRole("developer"), developerRoutes);

const PORT = process.env.PORT || 5000;
app.listen(PORT, () => {
  console.log("Backend running on port", PORT);
});
