const express = require('express');
const router = express.Router();
const pool = require('../db');

async function getWallet(conn, userId){
  const [[w]] = await conn.query('SELECT id,balance FROM wallets WHERE user_id=? FOR UPDATE', [userId]);
  if(w) return w;
  const [ins] = await conn.query('INSERT INTO wallets (user_id,balance) VALUES (?,0)', [userId]);
  return { id: ins.insertId, balance: 0 };
}

router.post('/user/request', async (req, res) => {
  const userId = req.body.user_id; // in production this will come from auth middleware
  const amount = Number(req.body.amount || 0);
  if(!userId) return res.status(400).json({ message: 'user_id required (for demo use)' });
  if(!amount || amount <= 0) return res.status(400).json({ message: 'invalid amount' });
  let conn;
  try {
    conn = await pool.getConnection();
    await conn.beginTransaction();
    const [[u]] = await conn.query('SELECT agent_id FROM users WHERE id=?', [userId]);
    const agentId = u ? u.agent_id : null;
    const wallet = await getWallet(conn, userId);
    if(wallet.balance < amount) throw new Error('not enough balance');
    await conn.query('UPDATE wallets SET balance = balance - ? WHERE id=?', [amount, wallet.id]);
    await conn.query('INSERT INTO coin_transactions (from_user_id,to_user_id,amount,type,metadata) VALUES (?,NULL,?, "withdraw_lock", JSON_OBJECT("agent_id",?))', [userId, amount, agentId]);
    const [ins] = await conn.query('INSERT INTO withdraw_requests (user_id,agent_id,amount,status) VALUES (?,?,?,"pending")', [userId, agentId, amount]);
    await conn.commit();
    res.json({ success: true, request_id: ins.insertId });
  } catch (e) {
    if(conn){ try{ await conn.rollback(); }catch{} conn.release(); }
    console.error(e); res.status(400).json({ message: e.message || 'failed' });
  } finally { if(conn) conn && conn.release(); }
});

module.exports = router;
